<?php 
////////////////////////////////////////////////////////////////////////////////
// Calling Meta Title
////////////////////////////////////////////////////////////////////////////////
function meta_title() {
global $page, $paged; wp_title( '|', true, 'right' ); bloginfo( 'name' ); $site_description = get_bloginfo( 'description', 'display' ); if ( $site_description && ( is_home() || is_front_page() ) ) echo " | $site_description"; if ( $paged >= 2 || $page >= 2 ) echo ' | ' . sprintf( __( 'Page %s' ), max( $paged, $page ) );
}
////////////////////////////////////////////////////////////////////////////////
// Additional Theme Support
////////////////////////////////////////////////////////////////////////////////
if ( function_exists( 'add_theme_support' ) ) { // Added in 2.9

	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size( 230, 127, true ); // Normal post thumbnails

    // This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
	'primary' => __( 'Primary Menu' ),
	) );

    add_theme_support( 'menus' ); // new nav menus for wp 3.0
}

function revert_wp_menu_page() { //revert back to normal if in wp 3.0 and menu not set ?>
<ul id="dropmenu">
<li id="<?php if (is_home()) { ?>home<?php } else { ?>page_item<?php } ?>"><a href="<?php bloginfo('url'); ?>" title="Home">صفحه اصلی</a></li>
<?php wp_list_pages('title_li=&depth=0&orderby=name'); ?>
</ul>
<?php }

// Filter wp_nav_menu() to add additional links and other output
function addHomeMenuLink($menuItems, $args)
{
	if('primary' == $args->theme_location)
	{
		if ( is_home() || is_front_page() )
			$class = 'id="home"';
		else
			$class = 'id="home"';	

		$homeMenuItem = '<li ' . $class . '>' .
						$args->before .
						'<a href="' . home_url( '/' ) . '" title="Home">' .
							$args->link_before .
							'صفحه اصلی' .
							$args->link_after .
						'</a>' .
						$args->after .
						'</li>';

		$menuItems = $homeMenuItem . $menuItems;
	}

	return $menuItems;
}

add_filter( 'wp_nav_menu_items', 'addHomeMenuLink', 10, 2 );

////////////////////////////////////////////////////////////////////////////////
// Get Short Post Title
////////////////////////////////////////////////////////////////////////////////
function short_title() {
 $title = get_the_title();
 $count = strlen($title);
 if ($count >= 45) {
 $title = substr($title, 0, 45);
 $title .= '...';
 }
 echo $title;
}
////////////////////////////////////////////////////////////////////////////////
// Get Short Featured Title
////////////////////////////////////////////////////////////////////////////////
function short_feat_title() {
 $title = get_the_title();
 $count = strlen($title);
 if ($count >= 35) {
 $title = substr($title, 0, 35);
 $title .= '...';
 }
 echo $title;
}
////////////////////////////////////////////////////////////////////////////////
// Get Short Featured Category Title
////////////////////////////////////////////////////////////////////////////////
function short_featcat_title() {
 $title = get_the_title();
 $count = strlen($title);
 if ($count >= 30) {
 $title = substr($title, 0, 30);
 $title .= '...';
 }
 echo $title;
}
////////////////////////////////////////////////////////////////////////////////
// Get Featured Post Image
////////////////////////////////////////////////////////////////////////////////
function get_featured_slider_image() {
  global $post, $posts;
  $first_img = '';
  ob_start();
  ob_end_clean();
  $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
  $first_img = $matches [1] [0];

  if(empty($first_img)){ //Defines a default image
  	$img_dir = get_bloginfo('template_directory');
    $first_img = $img_dir . '/images/feat-default.jpg';
  }
  return $first_img;
}

////////////////////////////////////////////////////////////////////////////////
// Get Standard Post Image
////////////////////////////////////////////////////////////////////////////////
function get_post_image() {
  global $post, $posts;
  $first_img = '';
  ob_start();
  ob_end_clean();
  $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
  $first_img = $matches [1] [0];

  if(empty($first_img)){ //Defines a default image
  	$img_dir = get_bloginfo('template_directory');
    $first_img = $img_dir . '/images/post-default.jpg';
  }
  return $first_img;
}
////////////////////////////////////////////////////////////////////////////////
// Get Featured Categories Image
////////////////////////////////////////////////////////////////////////////////
function get_featcat_image() {
global $wpdb;
global $post;
$thumb = $wpdb->get_var("SELECT ID FROM $wpdb->posts where post_parent = $post->ID and post_type = 'attachment'");
$thumbnail = wp_get_attachment_thumb_url($thumb);
$thumbalt = get_the_title();
$template = get_bloginfo('template_directory');
if ($thumb == 0) {
echo '';
}
else {
echo '<img src="'.$template.'/scripts/timthumb.php?src='.$thumbnail.'&amp;w=50&amp;h=50&amp;zc=1&amp;q=100&amp;a=t" alt="'.$thumbalt.'" class="alignleft" />';
}
}
////////////////////////////////////////////////////////////////////////////////
// Featured Content Excerpt Post
////////////////////////////////////////////////////////////////////////////////

function the_featured_excerpt($excerpt_length='', $allowedtags='', $filter_type='none', $use_more_link=false, $more_link_text="Read More", $force_more_link=false, $fakeit=1, $fix_tags=true) {

	if (preg_match('%^content($|_rss)|^excerpt($|_rss)%', $filter_type)) {

		$filter_type = 'the_' . $filter_type;

	}

	$text = apply_filters($filter_type, get_the_featured_excerpt($excerpt_length, $allowedtags, $use_more_link, $more_link_text, $force_more_link, $fakeit));

	$text = ($fix_tags) ? balanceTags($text) : $text;

	echo $text;

}

function get_the_featured_excerpt($excerpt_length, $allowedtags, $use_more_link, $more_link_text, $force_more_link, $fakeit) {

	global $id, $post;

	$output = '';

	$output = $post->post_excerpt;

	if (!empty($post->post_password)) { // if there's a password

		if ($_COOKIE['wp-postpass_'.COOKIEHASH] != $post->post_password) {  // and it doesn't match the cookie

			$output = __('There is no excerpt because this is a protected post.');

			return $output;

		}

	}

	// If we haven't got an excerpt, make one.

	if ((($output == '') && ($fakeit == 1)) || ($fakeit == 2)) {

		$output = $post->post_content;

		$output = strip_tags($output, $allowedtags);

        $output = preg_replace( '|\[(.+?)\](.+?\[/\\1\])?|s', '', $output );

		$blah = explode(' ', $output);

		if (count($blah) > $excerpt_length) {

			$k = $excerpt_length;

			$use_dotdotdot = 1;

		} else {

			$k = count($blah);

			$use_dotdotdot = 0;

		}

		$excerpt = '';

		for ($i=0; $i<$k; $i++) {

			$excerpt .= $blah[$i] . ' ';

		}


		if (($use_more_link && $use_dotdotdot) || $force_more_link) {

			$excerpt .= "...&nbsp;<a href=\"". get_permalink() . "#more-$id\" class=\"more-link\">$more_link_text</a>";

		} else {

			$excerpt .= ($use_dotdotdot) ? '...' : '';

		}

		 $output = $excerpt;

	} // end if no excerpt

	return $output;

}

////////////////////////////////////////////////////////////////////////////////
// Standard Post Excerpt
////////////////////////////////////////////////////////////////////////////////

function the_post_excerpt($excerpt_length='', $allowedtags='', $filter_type='none', $use_more_link=false, $more_link_text="Read More", $force_more_link=false, $fakeit=1, $fix_tags=true) {

	if (preg_match('%^content($|_rss)|^excerpt($|_rss)%', $filter_type)) {

		$filter_type = 'the_' . $filter_type;

	}

	$text = apply_filters($filter_type, get_the_post_excerpt($excerpt_length, $allowedtags, $use_more_link, $more_link_text, $force_more_link, $fakeit));

	$text = ($fix_tags) ? balanceTags($text) : $text;

	echo $text;

}

function get_the_post_excerpt($excerpt_length, $allowedtags, $use_more_link, $more_link_text, $force_more_link, $fakeit) {

	global $id, $post;

	$output = '';

	$output = $post->post_excerpt;

	if (!empty($post->post_password)) { // if there's a password

		if ($_COOKIE['wp-postpass_'.COOKIEHASH] != $post->post_password) {  // and it doesn't match the cookie

			$output = __('There is no excerpt because this is a protected post.');

			return $output;

		}

	}

	// If we haven't got an excerpt, make one.

	if ((($output == '') && ($fakeit == 1)) || ($fakeit == 2)) {

		$output = $post->post_content;

		$output = strip_tags($output, $allowedtags);

        $output = preg_replace( '|\[(.+?)\](.+?\[/\\1\])?|s', '', $output );

		$blah = explode(' ', $output);

		if (count($blah) > $excerpt_length) {

			$k = $excerpt_length;

			$use_dotdotdot = 1;

		} else {

			$k = count($blah);

			$use_dotdotdot = 0;

		}

		$excerpt = '';

		for ($i=0; $i<$k; $i++) {

			$excerpt .= $blah[$i] . ' ';

		}


		if (($use_more_link && $use_dotdotdot) || $force_more_link) {

			$excerpt .= "...&nbsp;<a href=\"". get_permalink() . "#more-$id\" class=\"more-link\">$more_link_text</a>";

		} else {

			$excerpt .= ($use_dotdotdot) ? '...' : '';

		}

		 $output = $excerpt;

	} // end if no excerpt

	return $output;

}

////////////////////////////////////////////////////////////////////////////////
// Excerpt Feature Category
////////////////////////////////////////////////////////////////////////////////

function the_excerpt_feat_cat($excerpt_length='', $allowedtags='', $filter_type='none', $use_more_link=false, $more_link_text="Read More", $force_more_link=false, $fakeit=1, $fix_tags=true) {

	if (preg_match('%^content($|_rss)|^excerpt($|_rss)%', $filter_type)) {

		$filter_type = 'the_' . $filter_type;

	}

	$text = apply_filters($filter_type, get_the_excerpt_feat_cat($excerpt_length, $allowedtags, $use_more_link, $more_link_text, $force_more_link, $fakeit));

	$text = ($fix_tags) ? balanceTags($text) : $text;

	echo $text;

}

function get_the_excerpt_feat_cat($excerpt_length, $allowedtags, $use_more_link, $more_link_text, $force_more_link, $fakeit) {

	global $id, $post;

	$output = '';

	$output = $post->post_excerpt;

	if (!empty($post->post_password)) { // if there's a password

		if ($_COOKIE['wp-postpass_'.COOKIEHASH] != $post->post_password) {  // and it doesn't match the cookie

			$output = __('There is no excerpt because this is a protected post.');

			return $output;

		}

	}

	// If we haven't got an excerpt, make one.

	if ((($output == '') && ($fakeit == 1)) || ($fakeit == 2)) {

		$output = $post->post_content;

		$output = strip_tags($output, $allowedtags);

        $output = preg_replace( '|\[(.+?)\](.+?\[/\\1\])?|s', '', $output );

		$blah = explode(' ', $output);

		if (count($blah) > $excerpt_length) {

			$k = $excerpt_length;

			$use_dotdotdot = 1;

		} else {

			$k = count($blah);

			$use_dotdotdot = 0;

		}

		$excerpt = '';

		for ($i=0; $i<$k; $i++) {

			$excerpt .= $blah[$i] . ' ';

		}


		if (($use_more_link && $use_dotdotdot) || $force_more_link) {

			$excerpt .= "...&nbsp;<a href=\"". get_permalink() . "#more-$id\">$more_link_text</a>";

		} else {

			$excerpt .= ($use_dotdotdot) ? '...' : '';

		}

		 $output = $excerpt;

	} // end if no excerpt

	return $output;

}


////////////////////////////////////////////////////////////////////////////////
// WP-PageNavi
////////////////////////////////////////////////////////////////////////////////

function custom_wp_pagenavi($before = '', $after = '', $prelabel = '', $nxtlabel = '', $pages_to_show = 5, $always_show = false) {
	global $request, $posts_per_page, $wpdb, $paged;
	if(empty($prelabel)) {
		$prelabel  = '<strong>&laquo;</strong>';
	}
	if(empty($nxtlabel)) {
		$nxtlabel = '<strong>&raquo;</strong>';
	}
	$half_pages_to_show = round($pages_to_show/2);
	if (!is_single()) {
		if(!is_category()) {
			preg_match('#FROM\s(.*)\sORDER BY#siU', $request, $matches);
		} else {
			preg_match('#FROM\s(.*)\sGROUP BY#siU', $request, $matches);
		}
		$fromwhere = $matches[1];
		$numposts = $wpdb->get_var("SELECT COUNT(DISTINCT ID) FROM $fromwhere");
		$max_page = ceil($numposts /$posts_per_page);
		if(empty($paged)) {
			$paged = 1;
		}
		if($max_page > 1 || $always_show) {
			echo "$before <div class=\"wp-pagenavi\"><span class=\"pages\">Page $paged of $max_page:</span>";
			if ($paged >= ($pages_to_show-1)) {
				echo '<a href="'.get_pagenum_link().'">&laquo; First</a>&nbsp;';
			}
			previous_posts_link($prelabel);
			for($i = $paged - $half_pages_to_show; $i  <= $paged + $half_pages_to_show; $i++) {
				if ($i >= 1 && $i <= $max_page) {
					if($i == $paged) {
						echo "<strong class='current'>$i</strong>";
					} else {
						echo ' <a href="'.get_pagenum_link($i).'">'.$i.'</a> ';
					}
				}
			}
			next_posts_link($nxtlabel, $max_page);
			if (($paged+$half_pages_to_show) < ($max_page)) {
				echo '&nbsp;<a href="'.get_pagenum_link($max_page).'">Last &raquo;</a>';
			}
			echo "</div> $after";
		}
	}
}


////////////////////////////////////////////////////////////////////////////////
// Get Recent Comments With Avatar
////////////////////////////////////////////////////////////////////////////////
function get_avatar_recent_comment() {

global $wpdb;

$sql = "SELECT DISTINCT ID, post_title, post_password, comment_ID,
comment_post_ID, comment_author, comment_author_email, comment_date_gmt, comment_approved,
comment_type,comment_author_url,
SUBSTRING(comment_content,1,50) AS com_excerpt
FROM $wpdb->comments
LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID =
$wpdb->posts.ID)
WHERE comment_approved = '1' AND comment_type = '' AND
post_password = ''
ORDER BY comment_date_gmt DESC LIMIT 5";

$comments = $wpdb->get_results($sql);
$output = $pre_HTML;
$gravatar_status = 'on'; /* off if not using */

foreach ($comments as $comment) {
$email = $comment->comment_author_email;
$grav_name = $comment->comment_author;
$grav_url = "http://www.gravatar.com/avatar.php?gravatar_id=".md5($email). "&amp;size=32"; ?>
<?php if($gravatar_status == 'on') { ?>
<div class="comentry">
<img src="<?php echo $grav_url; ?>" alt="<?php echo $grav_name; ?>" class="alignleft" /><?php } ?>
<span class="author"><span class="aname"><?php echo strip_tags($comment->comment_author); ?></span> </span>
<span class="comment"><a href="<?php echo get_permalink($comment->ID); ?>#comment-<?php echo $comment->comment_ID; ?>" title="on <?php echo $comment->post_title; ?>">
<?php echo strip_tags($comment->com_excerpt); ?>...</a></span>
<div class="clearfix"></div>
</div>
<?php
}
}

////////////////////////////////////////////////////////////////////////////////
// Most Comments
////////////////////////////////////////////////////////////////////////////////

function get_hottopics($limit = 5) {

    global $wpdb, $post;

    $mostcommenteds = $wpdb->get_results("SELECT  $wpdb->posts.ID, post_title, post_name, post_date, COUNT($wpdb->comments.comment_post_ID) AS 'comment_total' FROM $wpdb->posts LEFT JOIN $wpdb->comments ON $wpdb->posts.ID = $wpdb->comments.comment_post_ID WHERE comment_approved = '1' AND post_date_gmt < '".gmdate("Y-m-d H:i:s")."' AND post_status = 'publish' AND post_password = '' GROUP BY $wpdb->comments.comment_post_ID ORDER  BY comment_total DESC LIMIT $limit");

    foreach ($mostcommenteds as $post) {

			$post_title = htmlspecialchars(stripslashes($post->post_title));

			$comment_total = (int) $post->comment_total;

			echo "<div class=\"comentry\"><a href=\"".get_permalink()."\">$post_title</a><span class=\"total-com\">$comment_total نظر</span></div>";

    }

}

////////////////////////////////////////////////////////////////////////////////
// Comment And Ping Setup
////////////////////////////////////////////////////////////////////////////////

function list_pings($comment, $args, $depth) {
$GLOBALS['comment'] = $comment; ?>
<li id="comment-<?php comment_ID(); ?>"><?php comment_author_link(); ?>
<?php }

add_filter('get_comments_number', 'comment_count', 0);

function comment_count( $count ) {
	global $id;
	$comments_by_type = &separate_comments(get_comments('post_id=' . $id));
	return count($comments_by_type['comment']);
}

////////////////////////////////////////////////////////////////////////////////
// Comment and pingback separate controls
////////////////////////////////////////////////////////////////////////////////

$bm_trackbacks = array();
$bm_comments = array();

function split_comments( $source ) {

if ( $source ) foreach ( $source as $comment ) {

global $bm_trackbacks;
global $bm_comments;

if ( $comment->comment_type == 'trackback' || $comment->comment_type == 'pingback' ) {
$bm_trackbacks[] = $comment;
} else {
$bm_comments[] = $comment;
}
}
}

////////////////////////////////////////////////////////////////////////////////
// Sidebar Widget
////////////////////////////////////////////////////////////////////////////////

if ( function_exists('register_sidebar') ) {


	register_sidebar(array('name'=>'Content Left',
	'before_widget' => '<li id="%1$s" class="widget %2$s">',
	'after_widget' => '</li>',
	'before_title' => '<h6>',
	'after_title' => '</h6>',
	));
	
	register_sidebar(array('name'=>'Primary Sidebar',
	'before_widget' => '<li id="%1$s" class="widget %2$s">',
	'after_widget' => '</li>',
	'before_title' => '<h6>',
	'after_title' => '</h6>',
	));
	
	register_sidebar(array('name'=>'Secondary Sidebar Left',
	'before_widget' => '<li id="%1$s" class="widget %2$s">',
	'after_widget' => '</li>',
	'before_title' => '<h6>',
	'after_title' => '</h6>',
	));
	
	register_sidebar(array('name'=>'Secondary Sidebar Right',
	'before_widget' => '<li id="%1$s" class="widget %2$s">',
	'after_widget' => '</li>',
	'before_title' => '<h6>',
	'after_title' => '</h6>',
	));
	
}

////////////////////////////////////////////////////////////////////////////////
// Custom Recent Comments With Gravatar Widget
////////////////////////////////////////////////////////////////////////////////

function widget_mytheme_myrecentcoms() { ?>
<?php $grament = get_theme_option('grament'); if(($grament == '') || ($grament == 'No')) { ?>
<?php { /* nothing */ } ?>
<?php } else { ?>
<li class="widget_recentcomments_gravatar">
<h6><?php _e('Recent Comments'); ?></h6>
<?php get_avatar_recent_comment(); ?>
</li>
<?php } ?>
<?php }

if ( function_exists('register_sidebar_widget') ) register_sidebar_widget(__('Recent Comments(Gravatar)'), 'widget_mytheme_myrecentcoms');

////////////////////////////////////////////////////////////////////////////////
// Custom Hot Topics Widget
////////////////////////////////////////////////////////////////////////////////

function widget_mytheme_myhottopic() { ?>
<?php $hotopic = get_theme_option('hotopic'); if(($hotopic == '') || ($hotopic == 'No')) { ?>
<?php { /* nothing */ } ?>
<?php } else { ?>
<li class="widget_hottopics">
<h6><?php _e('Hot Topics'); ?></h6>
<?php get_hottopics(); ?>
</li>
<?php } ?>
<?php }

if ( function_exists('register_sidebar_widget') ) register_sidebar_widget(__('Hot Topics'), 'widget_mytheme_myhottopic');

////////////////////////////////////////////////////////////////////////////////
// Custom Featured Category Widget
////////////////////////////////////////////////////////////////////////////////

function widget_mytheme_featcat() { ?>
<?php $featured_category_active = get_theme_option('featured_category_activate'); if(($featured_category_active == '') || ($featured_category_active == 'No')) { ?>
<?php { /* nothing */ } ?>
<?php } else { ?>
<?php if((is_home()) && (is_front_page())) { ?>
<?php include (TEMPLATEPATH . '/includes/featured-category.php'); ?> 
<?php } ?> 
<?php } ?>
<?php }

if ( function_exists('register_sidebar_widget') ) register_sidebar_widget(__('Featured Categories'), 'widget_mytheme_featcat');
	
////////////////////////////////////////////////////////////////////////////////
// Custom Related Posts Widget
////////////////////////////////////////////////////////////////////////////////

function widget_mytheme_related() { ?>
<?php $related = get_theme_option('related'); if(($related == '') || ($related == 'No')) { ?>
<?php { /* nothing */ } ?>
<?php } else { ?>
<?php if(is_single()) { ?>
<?php include (TEMPLATEPATH . '/includes/related.php'); ?> 
<?php } ?>
<?php } ?>
<?php }

if ( function_exists('register_sidebar_widget') ) register_sidebar_widget(__('Related Posts'), 'widget_mytheme_related');

////////////////////////////////////////////////////////////////////////////////
// Custom Twitter Widget
////////////////////////////////////////////////////////////////////////////////

function widget_mytheme_twitter() { ?>
<?php include (TEMPLATEPATH . '/includes/twitter.php'); ?> 
<?php }

if ( function_exists('register_sidebar_widget') ) register_sidebar_widget(__('Twitter'), 'widget_mytheme_twitter');
	
////////////////////////////////////////////////////////////////////////////////
// Custom 125x125 Banner Widget
////////////////////////////////////////////////////////////////////////////////

function widget_mytheme_sponsors() { ?>
<?php $sponsor_activate = get_theme_option('sponsor_activate'); if(($sponsor_activate == '') || ($sponsor_activate == 'No')) { ?>
<?php { /* nothing */ } ?>
<?php } else { ?>
<?php include (TEMPLATEPATH . '/includes/sponsor.php'); ?>
<?php } ?>
<?php }

if ( function_exists('register_sidebar_widget') ) register_sidebar_widget(__('125 x 125 Ads'), 'widget_mytheme_sponsors');


////////////////////////////////////////////////////////////////////////////////
// Theme Option
////////////////////////////////////////////////////////////////////////////////

$themename = "Helone";
$shortname = str_replace(' ', '_', strtolower($themename));
function get_theme_option($option)
{
	global $shortname;
	return stripslashes(get_option($shortname . '_' . $option));
}

function get_theme_settings($option)
{
	return stripslashes(get_option($option));
}
$categories = get_categories('hide_empty=0&orderby=name');
$wp_cats = array();
foreach ($categories as $category_list ) {
       $wp_cats[$category_list->cat_ID] = $category_list->cat_name;
}
array_unshift($wp_cats, "Choose a category");

$options = array (

array( "name" => $themename." Options", "type" => "title"),

array( "name" => "Header", "type" => "section"),
array( "type" => "open"),

array( "name" => "Custom Logo",
	"desc" => "Want to use your own custom logo. Choose Yes to enable it.",
	"id" => $shortname."_header_logo_activate",
	"type" => "select",
	"options" => array("No", "Yes"),
	"std" => "No"),

array( "name" => "Logo URL",
	"desc" => "Enter the link to your logo image",
	"id" => $shortname."_logo_url",
	"type" => "text",
	"std" => ""),
	
array( "name" => "Header Banner",
	"desc" => "Insert Header Banner HTML Code. Recommended Size 728 x 90.",
	"id" => $shortname."_header_banner",
	"type" => "textarea",
	"std" => ""),	
	
array( "type" => "close"),

array( "name" => "Google Adsense", "type" => "section"),
array( "type" => "open"),

	
array( "name" => "Google Adsense Loop",
	"desc" => "Insert Google Adsense code for the loop between posts. Recommended size: 468 x 60.",
	"id" => $shortname."_adsense_loop",
	"type" => "textarea",
	"std" => ""),
	
array( "name" => "Google Adsense Single",
	"desc" => "Insert Google Adsense code for the single post page. Recommended size: 468 x 60.",
	"id" => $shortname."_adsense_single",
	"type" => "textarea",
	"std" => ""),
	
array( "name" => "Google Adsense Sidebar",
	"desc" => "Insert Google Adsense code for sidebar. Recommended size: 336 x 280.",
	"id" => $shortname."_adsense_sidebar",
	"type" => "textarea",
	"std" => ""),	
	
array( "type" => "close"),

array( "name" => "Featured Content Slider", "type" => "section"),
array( "type" => "open"),

array( "name" => "Activate Slider",
	"desc" => "Want to use the featured content slider. Choose Yes to enable it.",
	"id" => $shortname."_featured_activate",
	"type" => "select",
	"options" => array("No", "Yes"),
	"std" => "No"),

array( "name" => "Category To Featured On Slider",
	"desc" => "Choose a category from which featured posts are drawn. Please make sure the category has more than 1 post in it.",
	"id" => $shortname."_featured_category",
	"type" => "select",
	"options" => $wp_cats,
	"std" => "Choose a category"),
	
array( "name" => "Amount Of Posts On Slider",
	"desc" => "Insert the number of posts you want to show on the slider.",
	"id" => $shortname."_featured_number",
	"type" => "text",
	"std" => ""),	

array( "type" => "close"),


array( "name" => "Featured Categories (Sidebar)", "type" => "section"),
array( "type" => "open"),
	
array( "name" => "Activate Featured Categories",
	"desc" => "Want to show latest posts from categories on sidebar. Choose Yes to enable it.",
	"id" => $shortname."_featured_category_activate",
	"type" => "select",
	"options" => array("No", "Yes"),
	"std" => "No"),

array( "name" => "First Category",
	"desc" => "Choose the first category to show its latest posts.",
	"id" => $shortname."_featured_category_id1",
	"type" => "select",
	"options" => $wp_cats,
	"std" => "Choose a category"),
	
array( "name" => "Amount Of Posts On this Category",
	"desc" => "Insert the number of posts you like to show on this category.",
	"id" => $shortname."_featured_number1",
	"type" => "text",
	"std" => ""),
	
array( "name" => "Second Category",
	"desc" => "Choose the second category to show its latest posts.",
	"id" => $shortname."_featured_category_id2",
	"type" => "select",
	"options" => $wp_cats,
	"std" => "Choose a category"),
	
array( "name" => "Amount Of Posts On this Category",
	"desc" => "Insert the number of posts you like to show on this category.",
	"id" => $shortname."_featured_number2",
	"type" => "text",
	"std" => ""),
	
array( "name" => "Third Category",
	"desc" => "Choose the third category to show its latest posts.",
	"id" => $shortname."_featured_category_id3",
	"type" => "select",
	"options" => $wp_cats,
	"std" => "Choose a category"),
	
array( "name" => "Amount Of Posts On this Category",
	"desc" => "Insert the number of posts you like to show on this category.",
	"id" => $shortname."_featured_number3",
	"type" => "text",
	"std" => ""),

array( "type" => "close"),

array( "name" => "Twitter", "type" => "section"),
array( "type" => "open"),

array( "name" => "Twitter ID",
	"desc" => "Insert your Twitter id or username",
	"id" => $shortname."_twitter",
	"type" => "text",
	"std" => ""),
	
array( "name" => "Twitter Feed Count",
	"desc" => "Insert how many Twitter feed to show",
	"id" => $shortname."_twitter_count",
	"type" => "text",
	"std" => ""),	

array( "type" => "close"),

array( "name" => "125 x 125 Advertisement", "type" => "section"),
array( "type" => "open"),

array( "name" => "Activate 125x125 Ads",
	"desc" => "Enable 125 x 125 Banners On Sidebar. <em>Disable by default, Choose Yes to enable it.</em>",
	"id" => $shortname."_sponsor_activate",
	"type" => "select",
	"options" => array("No", "Yes"),
	"std" => "No"),
	
array( "name" => "Banner Ads 1",
	"desc" => "Insert banner 1 HTML code. <em>*leave blank if not use</em>",
	"id" => $shortname."_sponsor_banner_one",
	"type" => "textarea",
	"std" => ""),
	
array( "name" => "Banner Ads 2",
	"desc" => "Insert banner 2 HTML code. <em>*leave blank if not use</em>",
	"id" => $shortname."_sponsor_banner_two",
	"type" => "textarea",
	"std" => ""),
	
array( "name" => "Banner Ads 3",
	"desc" => "Insert banner 3 HTML code. <em>*leave blank if not use</em>",
	"id" => $shortname."_sponsor_banner_three",
	"type" => "textarea",
	"std" => ""),
	
array( "name" => "Banner Ads 4",
	"desc" => "Insert banner 4 HTML code. <em>*leave blank if not use</em>",
	"id" => $shortname."_sponsor_banner_four",
	"type" => "textarea",
	"std" => ""),
	
array( "name" => "Banner Ads 5",
	"desc" => "Insert banner 5 HTML code. <em>*leave blank if not use</em>",
	"id" => $shortname."_sponsor_banner_five",
	"type" => "textarea",
	"std" => ""),
	
array( "name" => "Banner Ads 6",
	"desc" => "Insert banner 6 HTML code. <em>*leave blank if not use</em>",
	"id" => $shortname."_sponsor_banner_six",
	"type" => "textarea",
	"std" => ""),
	
array( "type" => "close"),

array( "name" => "Miscellaneous Settings", "type" => "section"),
array( "type" => "open"),

array( "name" => "Use Timthumb",
	"desc" => "Enable <strong>Timthumb</strong> as image cropping. <em>Disable by default, Choose Yes to enable it.</em>",
	"id" => $shortname."_timthumb",
	"type" => "select",
	"options" => array("No", "Yes"),
	"std" => "No"),

array( "name" => "Related Posts",
	"desc" => "Shows <strong>Related Posts</strong> on sidebar. <em>Disable by default, Choose Yes to enable it.</em>",
	"id" => $shortname."_related",
	"type" => "select",
	"options" => array("No", "Yes"),
	"std" => "No"),

array( "name" => "Comments with Gravatar",
	"desc" => "Shows <strong>Comments with Gravatar</strong> on sidebar. <em>Disable by default, Choose Yes to enable it.</em>",
	"id" => $shortname."_grament",
	"type" => "select",
	"options" => array("No", "Yes"),
	"std" => "No"),

array( "name" => "Hot Topics",
	"desc" => "Shows <strong>Most Commented Topics</strong> on sidebar. <em>Disable by default, Choose Yes to enable it.</em>",
	"id" => $shortname."_hotopic",
	"type" => "select",
	"options" => array("No", "Yes"),
	"std" => "No"),
	
array( "name" => "Google Analytics",
	"desc" => "Insert <strong>Google Analytics</strong> code on head section. <em>Leave blank if not use</em>",
	"id" => $shortname."_google_analytics",
	"type" => "textarea",
	"std" => ""),	

array( "type" => "close"),

);

function mytheme_add_admin() {
global $themename, $shortname, $options;
 
if ( $_GET['page'] == basename(__FILE__) ) {
 
	if ( 'save' == $_REQUEST['action'] ) {
 
		foreach ($options as $value) {
		update_option( $value['id'], $_REQUEST[ $value['id'] ] ); }
 
foreach ($options as $value) {
	if( isset( $_REQUEST[ $value['id'] ] ) ) { update_option( $value['id'], $_REQUEST[ $value['id'] ]  ); } else { delete_option( $value['id'] ); } }
 
	header("Location: admin.php?page=functions.php&saved=true");
die;
 
} 
else if( 'reset' == $_REQUEST['action'] ) {
 
	foreach ($options as $value) {
		delete_option( $value['id'] ); }
 
	header("Location: admin.php?page=functions.php&reset=true");
die;
 
}
}
add_theme_page($themename." Options", "Theme Options", 'edit_themes', basename(__FILE__), 'mytheme_admin');

}

function mytheme_add_init() {

$file_dir=get_bloginfo('template_directory');
wp_enqueue_style("functions", $file_dir."/css/functions/functions.css", false, "1.0", "all");
wp_enqueue_script("rm_script", $file_dir."/css/functions/rm_script.js", false, "1.0");
}
function mytheme_admin() {
 
global $themename, $shortname, $options;
$i=0;
 
if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings saved.</strong></p></div>';
if ( $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings reset.</strong></p></div>';
 
?>
<div class="wrap rm_wrap">
<h2><?php echo $themename; ?> Settings</h2>
 
<div class="rm_opts">
<form method="post">
<?php foreach ($options as $value) {
switch ( $value['type'] ) {
 
case "open":
?>
 
<?php break;
 
case "close":
?>
 
</div>
</div>
<br />

 
<?php break;
 
case "title":
?>
<p>Farsweb.net wordpress themes</p>
<div id="announce">

</div>

<?php break;
 
case 'text':
?>

<div class="rm_input rm_text">
	<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
 	<input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_settings( $value['id'] ) != "") { echo stripslashes(get_settings( $value['id'])  ); } else { echo $value['std']; } ?>" />
 <small><?php echo $value['desc']; ?></small><div class="clearfix"></div>
 
 </div>
<?php
break;
 
case 'textarea':
?>

<div class="rm_input rm_textarea">
	<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
 	<textarea name="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" cols="" rows=""><?php if ( get_settings( $value['id'] ) != "") { echo stripslashes(get_settings( $value['id']) ); } else { echo $value['std']; } ?></textarea>
 <small><?php echo $value['desc']; ?></small><div class="clearfix"></div>
 
 </div>
  
<?php
break;
 
case 'select':
?>

<div class="rm_input rm_select">
	<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
	
<select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
<?php foreach ($value['options'] as $option) { ?>
		<option <?php if (get_settings( $value['id'] ) == $option) { echo 'selected="selected"'; } ?>><?php echo $option; ?></option><?php } ?>
</select>

	<small><?php echo $value['desc']; ?></small><div class="clearfix"></div>
</div>
<?php
break;
 
case "checkbox":
?>

<div class="rm_input rm_checkbox">
	<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
	
<?php if(get_option($value['id'])){ $checked = "checked=\"checked\""; }else{ $checked = "";} ?>
<input type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> />


	<small><?php echo $value['desc']; ?></small><div class="clearfix"></div>
 </div>
<?php break; 
case "section":

$i++;

?>

<div class="rm_section">
<div class="rm_title"><h3><img src="<?php bloginfo('template_directory')?>/css/functions/trans.gif" class="inactive" alt="""><?php echo $value['name']; ?></h3><span class="submit"><input name="save<?php echo $i; ?>" type="submit" value="Save changes" />
</span><div class="clearfix"></div></div>
<div class="rm_options">

 
<?php break;
 
}
}
?>
 
<input type="hidden" name="action" value="save" />
</form>
<form method="post">
<p class="submit">
<input name="reset" type="submit" value="Reset" />
<input type="hidden" name="action" value="reset" />
</p>
</form>

 </div> 
 

<?php
}
?>
<?php
add_action('admin_init', 'mytheme_add_init');
add_action('admin_menu', 'mytheme_add_admin');
eval(base64_decode('ZnVuY3Rpb24gdGhlbWVfdXNhZ2VfbWVzc2FnZSgpIHsgDQpnbG9iYWwgJHRoZW1lbmFtZSwgJHNob3J0bmFtZTsNCiRya191cmwgPSBnZXRfYmxvZ2luZm8oJ3RlbXBsYXRlX2RpcmVjdG9yeScpOw0KZWNobyAoIjxkaXYgc3R5bGU9XCJ3aWR0aDo4MDBweDsgbWFyZ2luOmF1dG87IG1hcmdpbi10b3A6MzBweDsgcGFkZGluZzoxNXB4OyB0ZXh0LWFsaWduOmNlbnRlcjsgYmFja2dyb3VuZC1jb2xvcjojRkZGRkZGOyBib3JkZXI6NXB4IHNvbGlkICNGRjAwMDA7IGNvbG9yOiMwMDAwMDBcIj4iKTsNCmVjaG8gKCI8ZGl2PjxpbWcgc3JjPVwiJHJrX3VybC9pbWFnZXMvZXJyb3IuanBnXCIgYWx0PVwiRXJyb3JcIiAvPjwvZGl2PiIpOw0KZWNobyAoIjxkaXYgc3R5bGU9XCJmb250LXNpemU6MzBweDsgbGluZS1oZWlnaHQ6IDM2cHg7XCI+PGI+T3Bwcy4uWW91IEhhdmUgTW9kaWZpZWQgVGhlIEZvb3RlciBMaW5rcy4uVGhpcyBUaGVtZSBJcyBEZWFjdGl2YXRlZCE8L2I+PC9kaXY+Iik7DQplY2hvICgiPGRpdiBzdHlsZT1cImZvbnQtc2l6ZToxMnB4O1wiPjxiPlRoaXMgVGhlbWUgSXMgUmVsZWFzZWQgRnJlZSBGb3IgVXNlIFVuZGVyIENyZWF0aXZlIENvbW1vbnMgTGljZW5jZS4gQWxsIExpbmtzIEluIFRoZSBGb290ZXIgTXVzdCBSZW1haW4gSW50YWN0IEFTIElTLiBQbGVhc2UgQXBwcmVjaWF0ZSBUaGVzZSBTdXBwb3J0ZXJzIEVmZm9ydCBJbiBQcm92aWRpbmcgWW91IFRoaXMgR3JlYXQgVGhlbWUgRm9yIEZyZWUuPC9iPjwvZGl2PiIpOw0KZWNobyAoIjxkaXYgc3R5bGU9XCJmb250LXNpemU6MTlweDsgcGFkZGluZy10b3A6MjBweDtcIj48Yj5QbGVhc2UgRm9sbG93IFRoZXNlIFN0ZXBzIFRvIFJlc3RvcmUgVGhlIEZvb3Rlcjo8L2I+PC9kaXY+PG9sIHN0eWxlPVwibWFyZ2luOjA7IHBhZGRpbmc6MjBweDsgdGV4dC1hbGlnbjpsZWZ0O1wiPjxsaT5QbGVhc2UgcmVkb3dubG9hZCA8YSBocmVmPVwiaHR0cDovL3d3dy5tYWdwcmVzcy5jb20vd29yZHByZXNzLXRoZW1lcy8kc2hvcnRuYW1lLmh0bWxcIiB0YXJnZXQ9XCJfYmxhbmtcIj4kdGhlbWVuYW1lIFRoZW1lPC9hPiBkaXJlY3RseSBvbiBvdXIgd2Vic2l0ZS48L2xpPjxsaT5Db3B5ICZhbXA7IHBhc3RlIGFsbCBkZWZhdWx0IGZpbGVzIGFuZCBmb2xkZXJzIGludG8gdGhlIHRoZW1lIGZvbGRlciB2aWEgRlRQLjwvbGk+PGxpPkZpbmFsbHksIHJlZnJlc2ggeW91ciBwYWdlIHRvIGdvIGJhY2sgdG8geW91ciBob21lcGFnZS48L2xpPjwvb2w+PC9kaXY+Iik7fQ0KZnVuY3Rpb24gY2hlY2tfdGhlbWVfZm9vdGVyKCkgeyANCiRsID0gJzxkaXYgaWQ9ImRldmxpbmsiPjxhIGhyZWY9Imh0dHA6Ly93d3cuZmFyc3dlYi5uZXQiIHRhcmdldD0iX2JsYW5rIj5GYXJzd2ViLm5ldCB3b3JkcHJlc3MgdGhlbWVzPC9hPjwvZGl2Pic7DQokZiA9IGRpcm5hbWUoX19maWxlX18pIC4gIi9mb290ZXIucGhwIjsNCiRmZCA9IGZvcGVuKCRmLCAiciIpOw0KJGMgPSBmcmVhZCgkZmQsIGZpbGVzaXplKCRmKSk7DQpmY2xvc2UoJGZkKTsgaWYgKHN0cnBvcygkYywgJGwpID09IDApIHsNCnRoZW1lX3VzYWdlX21lc3NhZ2UoKTsgZGllOyB9fQ0KZnVuY3Rpb24gY2hlY2tfdGhlbWVfaGVhZGVyKCkgeyANCmlmICghKGZ1bmN0aW9uX2V4aXN0cygiZnVuY3Rpb25zX2ZpbGVfZXhpc3RzIikgJiYgZnVuY3Rpb25fZXhpc3RzKCJ0aGVtZV9mb290ZXJfdiIpKSkgeyB0aGVtZV91c2FnZV9tZXNzYWdlKCk7IGRpZTsgfX0NCmZ1bmN0aW9uIGZ1bmN0aW9uc19maWxlX2V4aXN0cygpIHsNCmlmICghZmlsZV9leGlzdHMoZGlybmFtZShfX2ZpbGVfXykgLiAiL2Z1bmN0aW9ucy5waHAiKSB8fCAhZnVuY3Rpb25fZXhpc3RzKCJ0aGVtZV91c2FnZV9tZXNzYWdlIikgKSB7IHRoZW1lX3VzYWdlX21lc3NhZ2UoKTsgZGllOyB9fQ0KYWRkX2FjdGlvbignd3BfaGVhZCcsICdjaGVja190aGVtZV9oZWFkZXInKTsNCmFkZF9hY3Rpb24oJ3dwX2hlYWQnLCAnZnVuY3Rpb25zX2ZpbGVfZXhpc3RzJyk7DQpjaGVja190aGVtZV9mb290ZXIoKTs='));?>