<?php

    new Themater_AboutUs();
    
    class Themater_AboutUs
    {
        var $theme;
        
        var $defaults = array(
            'enabled' => 'true',
            'hook' => 'main_before',
            'title' => 'کاربر گرامی خوش آمدید',
            'content' => 'این نوشته تست می باشد '
        );
        
        function Themater_AboutUs()
        {
            global $theme;
            $this->theme = $theme;
            
            if(is_array($this->theme->options['plugins_options']['aboutus']) ) {
                $this->defaults = array_merge($this->defaults, $this->theme->options['plugins_options']['aboutus']);
            }
            
            $this->theme->add_hook($this->defaults['hook'], array($this, 'display_aboutus'));
            
            $this->aboutus_options();
            
        }

        
        function display_aboutus()
        {
            if(is_home() && $this->theme->display("aboutus_enabled") && $this->theme->display('aboutus_enabled') ) {
                ?><div class="span-24 aboutusbox">
                
                <?php 
                
                
                if($this->theme->display('aboutus_title')) {
                    echo '<h2 class="aboutusbox-title">' . $this->theme->get_option('aboutus_title') . '</h2>';
                }
                
                if($this->theme->display('aboutus_content')) {
                    echo '<div class="aboutusbox-content">' . $this->theme->get_option('aboutus_content') . '</div>';
                }
                ?></div><?php
            }
        }
        
        function aboutus_options()
        {
            $this->theme->admin_option(array('About Us', 14), 
                '"About Us" section enabled?', 'aboutus_enabled', 
                'checkbox', $this->defaults['enabled'], 
                array('display'=>'inline')
            );
            
            $this->theme->admin_option('About Us', 
                'Title', 'aboutus_title', 
                'text', $this->defaults['title']
            );
            
            $this->theme->admin_option('About Us', 
                'Content', 'aboutus_content', 
                'textarea', $this->defaults['content'],
                array('style'=>'height: 250px;')
            );
        }
    }
?>